<?php !defined( 'GROK' ) ?: exit( 'No direct script access allowed' );

/**
 * Class Utility
 *
 * A container for all things used everywhere. Included is a helper for
 * PDO connection which should really be refactored into its own Class.
 * Indeed, other items could also benefit from such an exercise:
 * api keymanagement, output manager/string parser prepper.
 *
 *
 */
class Utility
{
	/** 
	 * preDebugger() 
	 *  
	 * MCB preferred way of printing output to the browser
	 * during coding & non-customer-facing debugging.
	 *  
	*/
	public function preDebugger( $data, $color='#980000' )
    {
        print '<pre style="color: '.$color.'">';
        print_r($data);
        print '</pre>';

    } // preDebugger()

	/** 
	 * lDebugger() 
	 *  
	 * A method for printing output to the logs during coding & debugging.
	 *  
	*/
	public function lDebugger( $data )
    {
		$string = preg_replace('/\s\s+/', ' ', $data);
		error_log($string);

    } // logDebugger()

	/** 
	 *  
	 * output() 
	 *
	 * @param array     $data expects associative array
	 * @param string	$output
	 *  
	 */ 
	function output( $data, $output ) {

        // TODO: Refactor to kill the switch statement

		switch( $output )
		{
			case 'xml':
				$doc = new SimpleXMLElement("<root/>");
				header('Content-type: application/xml');
				$this->arrayToXml($data, $doc);
				print trim($doc->asXML());
				break;
			case 'json':
				header('Content-type: application/json');
				print trim( json_encode( $data ) );
				break;
            case 'raw':
            default:
                print_r($data);
                break;
		}
	}

    /**
     * @param array $CFG This can be done a dozen ways. For this exercise,
     *              we will just roll with passing in an array of params.
     * @return PDO
     */
    function initPDO( $CFG = array() ) {
		try 
		{
			$dbhost = $CFG['hostname'];
			$dbname = $CFG['database'];
			$dbuser = $CFG['username'];
			$dbpass = $CFG['password'];

			$conn = new PDO( "mysql:host=$hostname;dbname=$database", $username, $password );

			$conn->setAttribute(    PDO::ATTR_ERRMODE,
                                    PDO::ERRMODE_EXCEPTION);

			return $conn;
		}
		catch ( \PDOException $e )
		{
			die('PDOException : ' . $e->getMessage());
		}
	} // initPDO

    // TODO: Devise and include some API Key Management.

    static function updateApiKey() {}
	static function getNewApiKey() {return 'prefix_' . bin2hex( openssl_random_pseudo_bytes( 16 ) );}
	static function getUserApiKey($username) {}
	static function apiKeyReverseLookup($key) {}

	/** 
	 *  
	 * xmlEncode() 
	 *  
	 * shamelessly borrowed from somewhere out there -- probably a forum posting of some sort.
	 *  
	 */	 
	function arrayToXml($array, &$doc) {
		foreach($array as $key => $value) 
		{
			if(is_array($value)) 
			{
				if(!is_numeric($key)) 
				{
					$subnode = $doc->addChild("$key");
					$this->arrayToXml($value, $subnode);
				}
				else 
				{
					$this->arrayToXml($value, $doc);
				}
			}
			else 
			{
				$doc->addChild("$key","$value");
			}
		}
	} // arrayToXml()
}
?>
