<?php namespace CommPackager; !defined( 'GROK' ) ?: exit( 'No direct script access allowed' );
/**
* Communication Package Manager
*
* Facilitates data and intelligence gathering from various resources
* and customized package for the target service's consumption.
*
* A note on validation:
* Some rudimentary validation occurs here. However, we're rolling with
* the assumption that the controller is responsible for validation and
* that this is a utility function used by said controller.
*
* @package 	    CommPackager
* @author 		Marian C. Buford <mbuford@mariancbuford.com>
* @copyright	2014 mariancbuford.com
* @license 	    Beerware
* @link		    http://mariancbuford.com/projects/api.php
* @version 	    SVN: $Id$
*
*/
/**
 * TODO: Provide sql for creating tables used here.
 * TODO: Refactor to remove 'select *'
 */
/** This is	the	stuff that almost everything needs. */
require_once( 'Utility.php' );
class Utility extends \Utility {
    /**
     * Attempts to determine the requester's IP address
     */
    static function detectIP() {

        $ip = null;

        list( $ip ) = 	!empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ?
                        explode( ',', $_SERVER['HTTP_X_FORWARDED_FOR'] ) :
                        array( $_SERVER['REMOTE_ADDR'] );
        return $ip;

    } // detectIP

    /**
     * Strips anything but digits out of the return.
     *
     */
    static function cleanDigits( $string = null ) {
        if( null == $string) return null;

        return preg_replace( '/\D/', '', trim( $string ) );

    } // cleanDigits

    /**
     * Fetches the value assigned to the specified key from the
     * keyvalue table.
     */
    public function keyvalueLookup( $key = null ) {

        if( null === $key ) return false;

        return Utility::mockData( array() );

        try
        {
            $conn = Utility::initPDO();

            $sql = '
                SELECT `keyvalue`
                FROM keyvalue
                WHERE `key` = "' . $key . '";';

            $stmt = $conn->prepare( $sql );
            $stmt->execute();
            $row = $stmt->fetchObject();

            return $row->keyvalue;
        }
        catch( \Exception $e )
        {
            error_log( '[CommPackager Exception] method = ' . __FUNCTION__ . ' : line = ' . __LINE__ . ' : ' . $e->getMessage());
        }

        return null;

    } // keyvalueLookup

    /**
     * returns an object with the org and rt ids
     */
    static function convertDIDToId( $did = null ) {
        if( $did === null ) return false;

        return Utility::mocData( array( 'userid' => 123456 ) ); // remove this when database is in place

        try
        {
            $conn = Utility::initPDO();

            $sql = 'SELECT
                        user.id
                    FROM
                        `did`
                        LEFT JOIN `user`
                        ON did.user_id = user.id
                    WHERE
                        did.number = "' . $did . '"
                    LIMIT 1;';

            $stmt = $conn->prepare( $sql );
            $stmt->execute();

            if( $stmt->rowCount() > 0 )
            {
                return $stmt->fetchObject();
            }
            else
            {
                return false;
            }
        }
        catch(PDOException $e)
        {
            echo 'ERROR: ' . $e->getMessage();
            error_log( '[CommPackager Exception] method = ' . __FUNCTION__ . ' : line = ' . __LINE__ . ' : ' . $e->getMessage());
        }

        return false;

    } // convertDIDToId*/

    /**
     * Checks to see if requester is blacklisted.
     *
     * @param array $candidates accepts DIDs, IPs, userids, etc.
     * @return bool
     */
    function isBlocked( $candidates = array() ) {
        if( empty( $candidates ) ) return false;

        return true; // remove this when database is in place

        $conn = Utility::initPDO();

        $sql = '
            SELECT id
            FROM
                `blocked`
            WHERE
                `identifier` IN("' . implode( '","', $candidates ) . '")
                AND NOT `deleted` = true
                AND NOT `inactive` = true;';

        $stmt = $conn->prepare( $sql );
        $stmt->execute();

        if( $stmt->rowCount() > 0 )
        {
            $baddies = array();

            while( $row = $stmt->fetchObject() )
                array_push( $baddies, $row->identifier );

            $message = 'Blocking call involving identifer(s): ' . implode( ', ', $baddies ) ;
            error_log( '[CommPackager Notification] ' .  $message );
            return true;
        }

        return false;

    } // isBlocked


    /**
     * So that we can play without having a database
     */
    function mockData( $array = array() ) {

        if( !empty( $array ) )
        {
            $array = array(
                'userid'        => 123456,
                'username'      => 'elizabethkilligrew',
                'fullname'      => 'Elizabeth Killigrew',
                'nickname'      => 'Eliza',
                'ip'            => '209.132.183.105',
                'blacklisted'   => false,
                'did'           => '4045551212'
            );
        }

        $ret = new stdClass();
        foreach( $array as $key => $val )
        {
            $ret->$key = $val;
        }

        return $ret;
    }

} // CLASS Utility

class Package {

    function __construct() {} // CONSTRUCTOR

    function __destruct() {} // DESTRUCTOR

    /**
     * Creates the callHistory Record
     *
     * @param 	array params
     * @return 	commHistoryId
    */
    public function initUserCommunication( $params = array() ) {

        if( empty( $params ) ) return false;

        $commHistoryId = false;

        $historyCols = array(
            ':fromName' 			=> $params['username'],
            ':fromDID' 				=> $params['did'],
            ':fromIP' 				=> $params['ip'],
            ':commType'				=> $params['type'],
            ':userid' 		        => $params['userid'],
            ':openComm'				=> 1);

        try
        {
            $conn = Utility::initPDO();

            $conn->beginTransaction();

            // TODO:    Seems odd to keep metadata query separate -- refactor to include metadata in writeHistoryRecord()
            $metadataCols[':CallHistoryIdFK'] = Package::writeHistoryRecord( array(
                'conn' => $conn,
                'cols' => $historyCols ) );

            $sql = '
					INSERT INTO callhistory_metadata
						( `'. str_replace( ':', '', implode( '`,`', array_keys( $metadataCols ) ) ) .'`, `created` )
				 	VALUES
						( '. implode( ',', array_keys( $metadataCols ) ) .', utc_timestamp() );';

            $stmt = $conn->prepare( $sql, $metadataCols );

            $stmt->execute( $metadataCols );
            $conn->commit();
        }
        catch( \PDOException $e )
        {
            $conn->rollBack();
            echo 'ERROR: ' . $e->getMessage();
            error_log('ERROR: ' . $e->getMessage());
        }

        return $metadataCols[':CallHistoryIdFK']; // and it all comes down to this itsy bitsy number.

    } // initUserCommunication

    /**
     * Packages up the information needed by the requesting/target
     * system.
     *
     * @param array params
     *
     * requires commId and type, indicating user or org
    */
    public function routingPlan( $params = array() ) {

        if( empty( $params ) ) return false;

        $thisComm 	= null;
        $deck 		= array();
        $plan 		= array(
                        'error' => false,
                        'body' => array(
                                    'metadata' => array(),
                                    'routes' => array()
                        ) );

    /** first we need info from commhistory */
        try
        {
            $comm = Utility::initPDO();

            $sql = '
                    SELECT *
                    FROM
                        `callhistory` ch,
                        `callhistory_metadata` chm
                    WHERE
                        ch.CallHistoryId = ' . $params['commId'] . '
                        AND chm.CallHistoryIdFK = ' . $params['commId'] . '
                    LIMIT 1;';

            $stmt = $comm->prepare( $sql );
            $stmt->execute();

            if( $stmt->rowCount() > 0 )
            {
                $thisComm = $stmt->fetchObject();
            }
            else
            {
                throw new \PDOException( 'Unable to retrieve Comm History Record' );
            }
        }
        catch( \PDOException $e )
        {
            $plan['error'] = '[CommPackager Exception] method = ' . __FUNCTION__ . ' : line = ' . __LINE__ . ' : ' . $e->getMessage();
            error_log( '[CommPackager Exception] method = ' . __FUNCTION__ . ' : line = ' . __LINE__ . ' : ' . $e->getMessage());
            return $plan;
        }

        try
        {

            /* once caller/communication is identified, we can stack up whatever else the system needs to route the call to
            an agent/user */

        }
        catch( \PDOException $e )
        {
            $plan['error'] = '[CommPackager Exception] method = ' . __FUNCTION__ . ' : line = ' . __LINE__ . ' : ' . $e->getMessage();
            error_log( '[CommPackager Exception] method = ' . __FUNCTION__ . ' : line = ' . __LINE__ . ' : ' . $e->getMessage());
            return $plan;
        }
        return $plan;

    } // routingPlan


    private static function writeHistoryRecord( $params = array() ) {

        if( empty( $params ) ) return false;

        return true; // remove this when database is in place

        $conn = $params['conn'];

        $startTimeStampKey = isset($params['cols'][':startTimeStamp']) ? '`startTimeStamp`,' : ' ';
        $startTimeStampVal = isset($params['cols'][':startTimeStamp']) ? 'utc_timestamp(),' : ' ';

        unset($params['cols'][':startTimeStamp']);

        try
        {
            $sql = '
                INSERT INTO callhistory
                    ( `createdTimeStamp`, '.$startTimeStampKey.' `'. str_replace( ':', '', implode( '`,`', array_keys( $params['cols'] ) ) ) .'` )
                VALUES
                    ( utc_timestamp(), '.$startTimeStampVal.' '. implode( ',', array_keys( $params['cols'] ) ) .' );';

                $stmt = $conn->prepare( $sql, $params['cols'] );

                $stmt->execute( $params['cols'] );

                $commHistoryId = $conn->lastInsertId();

                return $commHistoryId;
        }
        catch( \Exception $e )
        {
            error_log( '[CommPackager Exception] method = ' . __FUNCTION__ . ' : line = ' . __LINE__ . ' : ' . $e->getMessage());
        }

        return false;

    } // writeHistoryRecord

    /**
     * Updates a comm history record.  This should generally be used when updating
     * a comm history item that is transitioning from one state to the next but
     * can be used to modify any column in the callhistory table.
     *
     * @param $params associative array containing at least the the comm history id
     * of the target record as 'commId' => $commId and a nested array identifying
     * the columns to be updated, 'cols' => array(':col1' => $data, ...).  Each
     * key name should begin with a colon and identify a column in the callhistory table.
     *
     * See the interaction between initCommunication and writeHistoryRecord as an
     * example.
     */
    public function updateRecord( $params ) {
        if( empty( $params ) ) return false;

        $conn = Utility::initPDO();
        $setSection = array();

        foreach ($params['cols'] as $k => $v) {
            $setSection[] = '`' .  str_replace(':', '', $k) . '` = ' . $k;
        }

        try
        {
            $sql = '
                UPDATE callhistory
                SET
                    ' . implode( ',', $setSection ) . '
                WHERE
                    `CallHistoryId` = ' .  $params['commId'] . ';';

                $stmt = $conn->prepare( $sql );

                $success = $stmt->execute( $params['cols'] );

                return array('success' => $success, 'rowsAffected' => $stmt->rowCount());
        }
        catch( \Exception $e )
        {
            error_log( '[CommPackager Exception] method = ' . __FUNCTION__ . ' : line = ' . __LINE__ . ' : ' . $e->getMessage());
        }

        return false;
    } // updateRecord


    /**
     * Sets the endTimeStamp and calculating calllength for video & chat communications
     */
    public function calculateCommunicationLength($params) {
        if( empty( $params ) && !(isset($params['commId']))) return false;

        $conn = Utility::initPDO();

        $sql = '
                                SELECT *
                                    FROM
                                        callhistory ch,
                                        callhistory_metadata chm
                                    WHERE
                                        chm.CallHistoryIdFK = ' . $params['commId'] . '
                                        AND chm.CallHistoryIdFK = ch.CallHistoryId
                                UNION
                                    SELECT *
                                    FROM
                                        callhistory ch,
                                        callhistory_metadata chm
                                    WHERE
                                        chm.CallHistoryIdFK = ' . $params['commId'] . '
                                        AND chm.xRef = ch.CallHistoryId
                                    LIMI 1';

        $stmt = $conn->prepare( $sql );
        $stmt->execute();


        if( $stmt->rowCount() > 0 )
        {
            $row = $stmt->fetchObject();
             $answeredTimeStamp = new \DateTime($row->answeredTimeStamp,new \DateTimeZone('UTC'));
            //date_default_timezone_set("UTC");
            $endTimeStamp = new \DateTime("now",new \DateTimeZone('UTC'));

            $call_ms = ($endTimeStamp->getTimestamp() - $answeredTimeStamp->getTimestamp()) * 1000;

            $cols = array(
                ':endTimeStamp'=>$endTimeStamp->format('Y-m-d H:i:s'),
                ':lengthOfCall_ms'=>$call_ms
            );

            Package::updateRecord(array('cols'=>$cols,'commId'=>$params['commId']));
        }
    }

    public function finalize( $params = array() ) {
        if( empty( $params ) || ! isset( $params['commId'] ) ||
                                ! isset( $params['isUser'] ) ) return false;

        try
        {
            /** do whatever is necessary to close the communication, including setting transaction counts & fees */
        }
        catch( \Exception $e )
        {
            error_log( '[CommPackager Exception] method = ' . __FUNCTION__ . ' : line = ' . __LINE__ . ' : ' . $e->getMessage());
        }

    } // Finalize

    /**
     * Closes the Comm Record
    */
    private static function closeRecord( $params = array() ) {

        try {

        \Utility::preDebugger( 'Record Closed' );

        }
        catch( \PDOException $e )
        {
            error_log( '[CommPackager Exception] method = ' . __FUNCTION__ . ' : line = ' . __LINE__ . ' : ' . $e->getMessage());
        }

    } // closeRecord

} // CLASS : Package
?>
