<?php !defined( 'GROK' ) ?: exit( 'No direct script access allowed' );
/*
 * MaxMind Adapter
 */

class ThirdPartyDataAdapter extends AdapterClass {

	private $connection;
    private $params;

	public function __construct( Options $options, Utility $utility ) {
		
		$this->init( $options, $utility );

		$this->connection = curl_init();
		$this->errors = array( "errors" => array() );
		$this->response = array();
		
		$this->fetch( $this->options );
	}
	
	public function __destruct() {
		curl_close($this->connection);
	}
	
	public function fetch( $options = null ) {

		if( empty( $options ) ) return false;
		
		$ip = filter_var( trim( $options->id ), FILTER_VALIDATE_IP );

		if($ip) 
		{	// http://dev.maxmind.com/geoip/legacy/web-services/
			
			$query = "http://geoip.maxmind.com/e?l=" . $this->options->conf['MAXMIND']['maxmind_license'] . "&i=" . $ip;

			$omni_keys =
			  array(
				'country_code',
				'country_name',
				'region_code',
				'region_name',
				'city_name',
				'latitude',
				'longitude',
				'metro_code',
				'area_code',
				'time_zone',
				'continent_code',
				'postal_code',
				'isp_name',
				'organization_name',
				'domain',
				'as_number',
				'netspeed',
				'user_type',
				'accuracy_radius',
				'country_confidence',
				'city_confidence',
				'region_confidence',
				'postal_confidence',
				'error'
				);

            // try to get data from cache first
            $cache_data = $this->cache->fetch($ip);
            if(isset($cache_data)) {
                // IP already in the cache
                $omni = $cache_data;
            } else {
                // Make geoip request
                $curl = curl_init();
                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => $query,
                        CURLOPT_USERAGENT => 'MaxMind PHP Sample',
                        CURLOPT_RETURNTRANSFER => true
                    )
                );

                $resp = curl_exec($curl);

                if (curl_errno($curl)) {
                    $this->setErrors('[MaxmindAdapter]  GeoIP request failed with a curl_errno of '. curl_errno($curl), 404); // 404 should be gentle enough for now
                }
                else
                {
                    $omni_values = str_getcsv($resp);
                    $omni_values = array_pad($omni_values, sizeof($omni_keys), '');
                    $omni = array_combine($omni_keys, $omni_values);

                    // store to cache
                    if(null == $omni['error'])
                        $this->cache->store($ip,$omni);
                    //error_log( json_encode( $omni ) );

                }
            }
            if( isset($omni) && (null == $omni['error']))
            {
                $vals = new stdClass;

                $vals->lon 			= $omni['longitude'];
                $vals->lat 			= $omni['latitude'];
                $vals->city 		= $omni['city_name'];
                $vals->state 		= $omni['region_name'];
                $vals->country		= $omni['country_name'];
                $vals->postalCode	= $omni['postal_code'];
                $vals->country_code = $omni['country_code'];

                $this->response = $vals;
            }
            else
            {
                $this->setErrors('[MaxmindAdapter] IP Address not found ', 404);
            }
        }
		else 
		{
			$this->setErrors("[MaxmindAdapter] Invalid IP address passed ", 400);
		}
		
		switch(true) {
			case empty($this->response) && empty($this->errors["errors"]):
		case !empty($this->response) && !empty($this->errors["errors"]):
				$this->setErrors('Unpossible', 720);
				break;
			case !empty($this->errors) && empty($this->response):
				$this->response = $this->errors; // this feels kludgy -- we have to pass errors into responses or the responses don't provide feedback at the end of the request.
				return $this->response;
				break;
			default:
				return $this->response;
				break;
		}
	} // fetch
}
?>