<?php !defined( 'GROK' ) ?: exit( 'No direct script access allowed' );

abstract class AdapterClass {

	public $results;
    public $errors = array();
    public $response;

	abstract public function fetch();
	
	function init( Options $options, Utility $utility ) {
		$this->options  = $options;
		$this->utility  = $utility;
	}

	public function setErrors($message, $code) {
		$error = array(
			"message" => $message,
			"code" => $code
		);
		array_push($this->errors["errors"], $error);
		error_log($error['message']);
		return $error;
	}

	public function getResponse() {
		return $this->response;
	}

	public function getOptions() {
		return $this->options;
	}

    public function setResults($type, $data) {
        array_push( $this->results->$type, $data );
        return $this;
    }

    public function getResults() {
        return $this->results;
    }

    public function log( $query, $from_cache = null, $result = null ) {}

    public function getCached($lookup) {}
}

?>