<?php if (!defined('SITEROOT')) exit('No direct script access allowed');
/*  =========================================================================
 *  ------------------------------ mcbdemo.php ------------------------------
 *                                   v 1.0
/**
 *  A class which provides the functionality for the basic demo projectlette.
 *  We'll include the model stuff here because it is a small application.
 *
 *  And, yup, I'm not commenting for phpDoc or other documentor in this
 *  exercise.
 *
 *  Created by:  Marian C. Buford
 *               mariancbuford.com (MCB)
 *  Created on:  07.09.2012
 *  License:     Beer-Ware
 *
 *  -------------------------------------------------------------------------
 *    "THE BEER-WARE LICENSE" (Revision 42):
 *    <marian[at]mariancbuford[dot]com> wrote this file. As long as you
 *    retain this notice you can do whatever you want with this stuff.
 *    If we meet some day, and you think this stuff is worth it, you can
 *    buy me a beer in return - Marian C. Buford
 *  -------------------------------------------------------------------------
 */
/*  ========================================================================= */
class MCBDemo
{
    private $p_connection   = '';
    private $p_allocations  = 0;

    private $p_queryResult  = null;
    private $p_errorMessage = null;
    private $p_successMessage = null;

/*  =========================================================================
    CONSTRUCTOR
    ========================================================================= */
    function __construct()
    {
        if (!is_resource($this->p_connection)) $this->p_allocations = 0;

        if (!$this->p_allocations++)
        {
            try
            {
                $this->p_connection = mysql_connect(SERVER, USERNAME, PASSWORD);
                mysql_select_db(DATABASE, $this->p_connection);
            }
            catch (Exception $e)
            {
                 printf("Connect failed: %s\n", mysqli_connect_error());
            }
        }

    } // CONSTRUCTOR

/*  =========================================================================
    DESTRUCTOR
    ========================================================================= */
    function __destruct() {
    } // DESTRUCTOR


/*  ** MODEL METHODS ******************************************************** */

    //TODO: query injection protection across the board.

/*  ========================================================================
    FUNCTION insert()
    --------------------------------- params --------------------------------
    $options    : array | for this exercise, we're trusting it is clean
                          and ready to rock.
    ======================================================================== */
    protected function insert($options = array())
    {
        if(empty($options)) return false;

        foreach($options as $key=>$value)
        {
            $keys[]     = $key;
            $values[]   = '"'.$value.'"';
        }

        $sql = 'INSERT INTO users_meta ';
        $sql .= '(' . implode(',',$keys) . ')';
        $sql .= 'VALUES(' . implode(',',$values) . ')';

        //$this->preDebugger($sql);

        if($karmaStack = $this->processQuery($sql,$this->sqlConnection(),'insert'))
            return $karmaStack;

        return false;
    } // insert()

/*  ========================================================================
    FUNCTION update()
    --------------------------------- params --------------------------------
    $options    : array | for this exercise, we're trusting it is clean
                          and ready to rock.
    ======================================================================== */
    protected function update($options = array())
    {
        if(empty($options)) return false;

        $values = null;

        $sql = 'UPDATE users_meta SET ';

        foreach($options as $key=>$value)
        {
            $values .= $key . '="' . $value . '",';
        }

        $sql .= rtrim($values,',');

        $sql .= ' WHERE id=' . $options['id'];

        if($this->processQuery($sql,$this->sqlConnection(),'update'))
            return true;

        return false;

    } // update()

/*  ========================================================================
    FUNCTION select()
    --------------------------------- params --------------------------------
    $options    : array
    ======================================================================== */
    protected function get($options = array())
    {
        if($options['id'] != 'all')
        {
            $sql = 'SELECT *
                    FROM users_meta
                    WHERE id=' . $options['id'] . '
                    LIMIT 1';

        }
        else
        {
            $sql = 'SELECT *
                    FROM users_meta
                    ORDER BY
                        lastname,
                        firstname';
        }

        if($result = $this->processQuery($sql,$this->sqlConnection(),'select'))
        {
            if($result['records'] != '0') return $result;
        }

        return false;

    } // select()

/*  ========================================================================
    FUNCTION delete()
    --------------------------------- params --------------------------------
    $options    : array
    ======================================================================== */
    protected function delete($id = null)
    {
        // normally, we'd like to push to update with a required flag of
        // not active, or flag that is used to deliniate "deleted" record.
        // for this exercise, we're not including a delete option.

        // presuming data has already been cleaned, this distills down to
        // [untested]:
        
        if($id == null) return false;

        if($this->update(array('id'=>$id,'active'=>1)))
            return false;
         
        return true;

    } // update()



/*  ** UTILITY METHODS ****************************************************** */

/*  =========================================================================
    FUNCTION: sqlConnection()
    ========================================================================= */
    protected function sqlConnection()
    {
        return $this->p_connection;
    } // sqlConnection()

/*  =========================================================================
    FUNCTION: setError()
    --------------------------------- params --------------------------------
    $options    : string
    ========================================================================= */
    protected function setError($string = null)
    {
        if(!$string == null) $this->p_errorMessage = $string;

    } // setError()

/*  =========================================================================
    FUNCTION: hasError()
    ========================================================================= */
    public function hasError()
    {
        return !!$this->p_errorMessage;

    } // hasError()

/*  =========================================================================
    FUNCTION: adminError()
    --------------------------------- notes ---------------------------------
    Normally, we'd set up message strings in a string/language file. For now,
    we'll create and pass them as we need them.
    ========================================================================= */
    public function adminError()
    {
        $message = $this->p_errorMessage !== null ? $this->p_errorMessage :
                   'A general error occurred.<br />';

        $message .= 'Please try again.<br />If the problem persists,
                     contact the help desk.';

        print '<div class="error">' . $message . '</div>';

        $this->p_errorMessage = null;

        return false;

    } // adminError()

/*  =========================================================================
    FUNCTION: setSuccess()
    --------------------------------- params --------------------------------
    $options    : string
    ========================================================================= */
    protected function setSuccess($string = null)
    {
        if(!$string == null) $this->p_successMessage = $string;

    } // setSuccess()

/*  =========================================================================
    FUNCTION: hasSuccess()
    ========================================================================= */
    public function hasSuccess()
    {
        return !!$this->p_successMessage;

    } // hasSuccess()

/*  =========================================================================
    FUNCTION: adminSuccess()
    --------------------------------- notes ---------------------------------
    Normally, we'd set up message strings in a string/language file. For now,
    we'll create and pass them as we need them.
    ========================================================================= */
    public function adminSuccess()
    {
        $message = $this->p_successMessage !== null ? $this->p_successMessage :
                   'Your request was successful.<br />';

        print '<div class="success">' . $message . '</div>';

        $this->p_successMessage = null;

    } // adminSuccess()

/*  =========================================================================
    FUNCTION: processQuery()
    --------------------------------- params --------------------------------
    $sql        : a properly formed, validated sql string
    $connection : the connection object
    $type       : a hint for how to handle the query; lowercase string
                  denoting typical query functions "select", "update", etc.

    --------------------------------- notes ---------------------------------
    I'ts tempting to not send in the connection and to just use "this->. . ."
    -- remember that we may use two connections: one for replica master,
    the other for replica slave.
    ========================================================================= */
    protected function processQuery($sql = null,$connection = null,$type = null)
    {
       //$result = mysql_query($sql,$connection);

       if($sql !== null && is_resource($connection))
       {
            $result = mysql_query($sql,$connection);
            //$this->preDebugger($sql);
            //$this->preDebugger($result);

            $records = mysql_affected_rows($connection);

            //$this->preDebugger($records);

            switch ($type) {
                case 'update':
                    $return = '';
                    break;
                case 'select':
                    $return = array();
                    while($row = mysql_fetch_object($result)) $return[] = $row;
                    break;
                case 'insert':
                    $return = mysql_insert_id($connection);
                    break;
                case 'delete':
                    $return = '';
                    break;
                default:
                    return $result;
            }

            return array(
                'message'=>"Number of records involved: $records",
                'records'=>$records,
                'items'=>$return);  //to manage this, use is_array() . . .

       }
       else
       {
           $this->p_errorMessage = mysql_error($connection);
           return false;
       }

    } // processQuery()

/*  =========================================================================
    FUNCTION required()
    --------------------------------- params --------------------------------
    $required   : array
    $data       : array
    ========================================================================= */
    protected function required($required, $data)
    {
        if(!is_array($data)) return false;

        foreach($required as $field)
            if(!isset($data[$field])) return false;

        return true;

    } // required()

/*  =========================================================================
    FUNCTION: isValid()
    --------------------------------- params --------------------------------
    $string     : string
    $type       : email
    ========================================================================= */
    protected function isValid($string, $type)
    {
        // we could set up a switch case here.  For now; we'll just check
        // email validity and we'll lazy load in a class that's been a go-to
        // reference for a bajillion years in order to save some time.
        // http://php-email-address-validation.googlecode.com/svn/trunk/EmailAddressValidator.php

        include('util/third-party/EmailAddressValidator.php'); // TODO: fix this bad practice;
                                                   // if you change file structure
                                                   // you're screwed.

        $emailValidator = new EmailAddressValidator;
        return $emailValidator->check_email_address($string);

    } // isValid()

/*  =========================================================================
    FUNCTION: preDebugger()
    --------------------------------- params --------------------------------
    $data       : accepts string or array
    $color      : any valid css input to 'color'

    --------------------------------- notes ---------------------------------
    Just a quickie method to help when we're troubleshooting/testing.  Using
    the pre tags ensures that no matter where we are in the UI, we can echo
    out a treed array.  Incidentally it will also spit out strings.
    Color coding helps when dealing with large renderings with multiple bits
    and pieces that need to be checked.
    ========================================================================= */
    protected function preDebugger($data,$color='#980000')
    {
        print '<pre style="color: '.$color.'">';
        print_r($data);
        print '</pre>';

    } // preDebugger()


}
/*  ---------------------------- eof mcbdemo.php ---------------------------- */
?>