<?php if (!defined('SITEROOT')) exit('No direct script access allowed');
/*  =========================================================================
 *  ----------------------------- eof Users.php -----------------------------
 *                                    v 1.0
/**
 *  The Users class.  A basic controller for the  demo projectlette.
 *  And, yup, I'm not commenting for documenter in this exercise.
 *
 *  Created by:  Marian C. Buford
 *               mariancbuford.com (MCB)
 *  Created on:  07.09.2012
 *  License:     Beer-Ware
 *
 *  -------------------------------------------------------------------------
 *    "THE BEER-WARE LICENSE" (Revision 42):
 *    <marian[at]mariancbuford[dot]com> wrote this file. As long as you
 *    retain this notice you can do whatever you want with this stuff.
 *    If we meet some day, and you think this stuff is worth it, you can
 *    buy me a beer in return - Marian C. Buford
 *  -------------------------------------------------------------------------
 */
/*  ========================================================================= */
class Users extends MCBDemo
{
/*  =========================================================================
    CONSTRUCTOR
    ========================================================================= */
    function __construct()
    {
        parent::__construct();

    } // CONSTRUCTOR

/*  =========================================================================
    DESTRUCTOR
    ========================================================================= */
    function __destruct()
    {
        parent::__destruct();
    } // DESTRUCTOR

/*  =========================================================================
    FUNCTION: insertUser()
    ========================================================================= */
    public function insertUser()
    {
        $options = $_POST;

        //$this->preDebugger($options);

        $requiredItems = array('firstname','lastname','email','sex','city',
              'state','comments');

        if(!$this->required($requiredItems,$options))
        { // normally, we'd detail this but for expediency we'll use a
          //blanket statement
            $this->setError('The form is incomplete.<br />');
            return false;
        }

        if(!$this->isValid($options['email'],'email'))
        {
            $this->setError('Check the email address. It appears invalid.<br />');
            return false;
        }
        
        $options['karma'] = $this->fibonacciMaru(strlen($options['firstname']) +
                                                 strlen($options['lastname']));

        if(!$result = $this->insert($options))
        {
            $this->setError('Unable to insert user.<br />');
        }
        else
        {
            $successString = 'Added user with id ' . $result['items'] . '.<br />';
            $successString .= '<a href="index.php">Add Another</a>';
            $this->setSuccess($successString);
            unset($_POST);
            $_POST = array();
        }

    } //insertUser();

/*  =========================================================================
    FUNCTION: updateUser()
    ========================================================================= */
    public function updateUser()
    { // this and insert user present opportunities for a little forking
      // since they are processing the data nearly identically.
        $options = $_POST;

        $requiredItems = array('firstname','lastname','email','sex','city',
              'state','comments');

        if(!$this->required($requiredItems,$options))
        { // normally, we'd detail the fields but for expediency we'll use a
          //blanket statement
            $this->setError('The form is incomplete.<br />');
            return false;
        }

        if(!$this->isValid($options['email'],'email'))
        {
            $this->setError('Check the email address. It appears invalid.<br />');
            return false;
        }
        
        $options['karma'] = $this->fibonacciMaru(strlen($options['firstname']) +
                                                 strlen($options['lastname']));


        if(!$result = $this->update($options))
        {
            $this->setError('Unable to update user.<br />');
        }
        else
        {
            $successString = 'Updated user with id ' . $options['id'] . '.<br />';
            $this->setSuccess($successString);
        }

    } //updateUser();

/*  =========================================================================
    FUNCTION: getAllUsers()
    ========================================================================= */
    public function getAllUsers()
    {
        // normally, I'm not fond of passing anything but an id via id
        // but it will get the job done for now.

        $options['id'] = 'all';

        if(!$userData = $this->get($options))
        {
            $this->setError('Unable to get the users.<br />');
            return false;
        }

        return $userData;

    } //getAllUsers();

/*  =========================================================================
    FUNCTION: getUser()
    ========================================================================= */
    public function getUser()
    {
        $options = $_GET;

        //$this->preDebugger($options);

        $requiredItems = array('id');

        if(!$this->required($requiredItems,$options))
        {
            $this->setError('No user selected.<br />');
            return false;
        }

        if(!$userData = $this->get($options))
        {
            $this->setError('Unable to find the selected user.<br />');
            return false;
        }

        //$this->preDebugger($userData);
        // I can get away with this 'cause we know there's only one record
        foreach($userData['items'][0] as $key=>$value)
        {
            $userStack[$key] = $value;
        }
        return $userStack;

    } //getUser();

/*  =========================================================================
    FUNCTION: fibonacciMaru()
    ========================================================================= */
    private function fibonacciMaru($seed = 0)
    {
        $a = 0;
        $b = 1;

        try
        {
            for ($i = 0; $i < $seed; $i++)
            {
                $sum = $a+$b;
                $a = $b;
                $b = $sum;
            }
        }
        catch (Exception $e)
        {
            printf("Crash and burn.");
        }

        return $a;

    } // fibonacciMaru()

}
/*  ----------------------------- eof Users.php ----------------------------- */
?>