<?php
    /* MCB Says:
     
       This page, displays data based on conditions and effectively displays
       three different pages:
           * Add User
           * Add Confirmation
           * Edit User
     
       The third view (mcbdemo_view3.php) demonstrates a different method of
       calling a page. The third view is a stand-alone page. It includes the
       header/footer information and then renders itself.  We could as easily
       have set this page up to show what the third page does by modifying
       the little conditional statement below. But, this is an exercise so
       we're stretching a different muscle through the third page.
     
       There's no *right* way to do this; one has to make the decision based
       on what you want to do now versus where you want to take the site.
     
       If you anticipate the site is going to go large, then the method used
       in this page will get ungainly after a while. It becomes more and more
       difficult to fork off bits and pieces to extend them . . .hmmmm . . .
       something like the difference between arranging pretzel sticks versus
       trying to separate raisins from cooked oatmeal. This is oatmeal; the
       third page is pretzels.
     
       BUT.  If the site, like this demo, is going to remain small, it works
       to keep things all in one file and is a good exercise in rendering a
       page based on conditions.
     
       */

    define('SITEROOT','./');
    require_once(SITEROOT . 'config.php');
    require_once(SITEROOT . 'MCBDemo.php');
    require_once(SITEROOT . 'Users.php');
    require_once(SITEROOT . 'data/states.php');

    $oUsers = new Users;

    $data = array();
    $task = null;
    $userList = array();

    if(isset($_GET['id']))
    {
        if(isset($_POST['id']) && $_POST['id'] != '')
        {
            $oUsers->updateUser();
        }

        $data = $oUsers->getUser($_GET['id']);
        $task = 'edit';
    }
    else
    {
        if(isset($_POST['firstname']))
        {
            $oUsers->insertUser();

            $data = $_POST;
        }
    }

    $userList = $oUsers->getAllUsers();
    $genders = array('F'=>'Female','M'=>'Male');

    // the multiple breaks in ?php blocks don't make sense until you 
    // start fleshing out the page; then you're happy to have them.
?>
<?php require_once(SITEROOT . 'head.php'); ?>
<!-- a little html can go here; maybe message handling toasters or something -->
<?php
    if($oUsers->hasError()) print $oUsers->adminError();

    if($oUsers->hasSuccess())
    {
        print $oUsers->adminSuccess();
        if(isset($_GET['id']))
            require_once(SITEROOT . 'mcbdemo_form.php');
    }
    else
    {
        require_once(SITEROOT . 'mcbdemo_form.php');
    }

?>
<!-- a little more html can go here and what follows might be conditional -->

        <div class="viewBlock"><?php require_once(SITEROOT . 'mcbdemo_view1.php'); ?></div>
        <div class="viewBlock"><?php require_once(SITEROOT . 'mcbdemo_view2.php'); ?></div>
<!-- still more html can go here  -->
<?php require_once(SITEROOT . 'foot.php'); ?>
