<?php
    $taskLabel = $task == 'edit' ? 'Apply Change' : 'Add Me';
?>
<div class="formBlock">
    <div class="formInstructions">All fields are required unless otherwise indicated.</div>
    <?php if($task == 'edit'): ?>
    <h1><?php print $data['firstname']; ?> <?php print $data['lastname']; ?></h1>
    <h2><?php print $data['karma']; ?> karma</h2>
    <?php endif; ?>
    <form method="POST" action="<?php print $_SERVER['PHP_SELF']; print isset($data['id']) ? '?id=' . $data['id'] : ''; ?>" >
        <div class="formRow">
            <div class="formLabel">First Name:</div>
            <div class="formField"><input id="firstname" name="firstname" type="text" placeholder="Your First Name" value="<?php print isset($data['firstname']) ? $data['firstname'] : ''; ?>" required /></div>
        </div>
        <div class="formRow">
            <div class="formLabel">Last Name:</div>
            <div class="formField"><input id="lastname" name="lastname" type="text" placeholder="Your Last Name" value="<?php print isset($data['lastname']) ? $data['lastname'] : ''; ?>" required /></div>
        </div>
        <div class="formRow">
            <div class="formLabel">Email:</div>
            <div class="formField"><input id="email" name="email" type="email" placeholder="Your Email Address" value="<?php print isset($data['email']) ? $data['email'] : ''; ?>" required /></div>
        </div>
        <div class="formRow">
            <div class="formLabel">Sex:</div>
            <div class="formField">
                <?php foreach($genders as $key=>$value):
                    $checked = isset($data['sex']) &&  $data['sex']  == $key ? 'checked' : '';?>
                    <input id="sex_<?php print $key; ?>" name="sex" type="radio" value="<?php print $key; ?>" <?php print $checked; ?> > <?php print $value; ?>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="formRow">
            <div class="formLabel">City:</div>
            <div class="formField"><input id="city" name="city" type="text" placeholder="" value="<?php print isset($data['city']) ? $data['city'] : ''; ?>" required /></div>
        </div>
        <div class="formRow">
            <div class="formLabel">State:</div>
            <div class="formField">
                <select id="state" name="state"/>
                <?php foreach($states as $key=>$value):
                    $selected = isset($data['state']) &&  $data['state']  == $key ? 'selected' : '';?>
                    <option value="<?php print $key; ?>" <?php print $selected; ?> ><?php print $value; ?></option>
                <?php endforeach; ?>
                </select>
            </div>
        </div>
        <div class="formRow">
            <div class="formLabel">Comments:</div>
            <div class="formField"><textarea id="comments" name="comments" placeholder="Say Something" required ><?php print isset($data['comments']) ? $data['comments'] : ''; ?></textarea></div>
        </div>
        <div class="buttonRow">
            <input id="id" name="id" type="hidden" value="<?php print isset($data['id']) ? $data['id'] : ''; ?>" />
            <input type="submit" placeholder="" value="<?php print $taskLabel; ?>" />
        </div>
    </form>

</div>