<?php
/*  =========================================================================
 *  --------------------------- paintADragon.php ----------------------------
 *                                   v 0.75
/**
 *  Apply a color to a simple image.
 *
 *  Created by: Marian C. Buford
 *              mariancbuford.com (MCB)
 *  Created on: 06.10.2012
 *  License:    Beer-Ware
 *
 *  -------------------------------------------------------------------------
 *    "THE BEER-WARE LICENSE" (Revision 42):
 *    <marian[at]mariancbuford[dot]com> wrote this file. As long as you
 *    retain this notice you can do whatever you want with this stuff. If we
 *    meet some day, and you think this stuff is worth it, you can buy me a
 *    beer in return - Marian C. Buford
 *  -------------------------------------------------------------------------
 *
 * @return image
 *
 */
/*  ========================================================================= */

    // Our little dragon is comprised of four layers.  There are two versions,
    // one facing east, the other west.  The url request will let us know which
    // template is desired.  The layers that are receiving a color treatment
    // are sampled as 8-bit png.
    //
    // We'll want to color three of the layers; the fourth is a shadow.  We'll
    // bring in the Shades class to help us adjust the shade of the requested
    // color that is sent in through the url request.
    //
    // Lastly, we'll stack the layers and output the result; or an error image
    // if the stacking and shading attempt is not successful.
    //
    // The template images are stored in the same directory as this file, so
    // we need not concern ourselves with paths.  For now ;)
    define('SITEROOT','');
    require_once(SITEROOT . 'Shades.php');

    $templateNumber = $_GET['template'];
    $color	    = $_GET['color'];

    $oShades = new Shades($color);
    
    // load up the skin template
    $skin	= loadTemplate('images/dragon_templates/skin_' . $templateNumber . '.png');
    $veins	= loadTemplate('images/dragon_templates/wing_veins_' . $templateNumber . '.png');
    $outline	= loadTemplate('images/dragon_templates/outline_' . $templateNumber . '.png');
    $shadow	= loadTemplate('images/dragon_templates/shadow_' . $templateNumber . '.png');

    $finalImage = $shadow;
// TODO: thrice is not nice -- make this set a function.
    $layerColor = $oShades->hex2RGB($oShades->palette['0']);
    $layer = paintLayer($skin,$layerColor[0],$layerColor[1],$layerColor[2]);
    imagecopy ($finalImage,$layer ,0,0,0,0,imagesx($finalImage),imagesy($finalImage));

    $layerColor = $oShades->hex2RGB($oShades->palette['+30']);
    $layer = paintLayer($veins,$layerColor[0],$layerColor[1],$layerColor[2]);
    imagecopy ($finalImage,$layer ,0,0,0,0,imagesx($finalImage),imagesy($finalImage));

    $layerColor = $oShades->hex2RGB($oShades->palette['+40']);
    $layer = paintLayer($outline,$layerColor[0],$layerColor[1],$layerColor[2]);
    imagecopy ($finalImage,$layer ,0,0,0,0,imagesx($finalImage),imagesy($finalImage));

    outputImage($finalImage,false);

/*  =========================================================================
    FUNCTION: paintLayer()
    ========================================================================= */
    function paintLayer($layer,$r,$g,$b)
    {
	for ($x = 0; $x < imagesx($layer); $x++)
	{
	    for ($y = 0; $y < imagesy($layer); $y++)
	    {
		$inx = imagecolorexact($layer,0,0,0);
		imagecolorset($layer,$inx,$r,$g,$b);
	    }
	}
	return $layer;
    } // paintLayer

/*  =========================================================================
    FUNCTION: loadTemplate()
    ========================================================================= */
    function loadTemplate($templateName)
    {
	// load the file but supress the error
	$template = @imagecreatefrompng($templateName);

	// check to see if the file loaded, else handle the error
	if(!$template) generateErrorImage($templateName);

	// if all is okay, return the result
	return $template;

    } // loadTemplate()

/*  =========================================================================
    FUNCTION: generateErrorImage()
    ========================================================================= */
    function generateErrorImage($imageName)
    {
	$im  = imagecreatetruecolor(200, 20);
	$bgc = imagecolorallocate($im, 255, 255, 255);
	$tc  = imagecolorallocate($im, 148, 0, 0);

	imagefilledrectangle($im, 0, 0, 200, 20, $bgc);

	imagestring($im, 3, 5, 5, 'Error loading ' . $imageName, $tc);

	outputImage($im);
    } // generateErrorImage()

/*  =========================================================================
    FUNCTION: outputImage()
    ========================================================================= */
    function outputImage($im,$suppressHeader = false)
    {
	if(!$suppressHeader) header( "Content-Type: image/png" );

	imagealphablending($im, true);
	imagesavealpha($im, true);
	imagepng($im);

	imagedestroy($im);
    } // outputImage()

/*  ---------------------------- paintImage.php ----------------------------- */
?>