<?php if (!defined('SITEROOT')) exit('No direct script access allowed');
/*  =========================================================================
 *  ------------------------------ Colors.php -------------------------------
 *                                   v 0.75
/**
 *  A class which provides some fun tools for working with colors.
 *
 *  Created by: Marian C. Buford
 *              mariancbuford.com (MCB)
 *  Created on: 07.02.2010
 *  License:    Beer-Ware
 *
 *  -------------------------------------------------------------------------
 *    "THE BEER-WARE LICENSE" (Revision 42):
 *    <marian[at]mariancbuford[dot]com> wrote this file. As long as you
 *    retain this notice you can do whatever you want with this stuff. If we
 *    meet some day, and you think this stuff is worth it, you can buy me a
 *    beer in return - Marian C. Buford
 *  -------------------------------------------------------------------------
 */
/*  ========================================================================= */
class Colors
{
/*  =========================================================================
    CONSTRUCTOR
    ========================================================================= */
    function __construct()
    {
    } // CONSTRUCTOR

/*  =========================================================================
    DESTRUCTOR
    ========================================================================= */
    function __destruct() {
   } // DESTRUCTOR

/*  =========================================================================
    FUNCTION: generateRandom()
    ========================================================================= */
    public function generateRandom($quantity = null)
    {
	$i = 0;

	$colorArray = array();

	if($quantity === null) $quantity = rand(1,100);

	while($i < $quantity)
	{
	    $r = dechex(rand(0,255));
	    $g = dechex(rand(0,255));
	    $b = dechex(rand(0,255));

	    // zero fill
	    if(strlen($r) < 2) $r = '0' . $r;
	    if(strlen($g) < 2) $g = '0' . $g;
	    if(strlen($b) < 2) $b = '0' . $b;

	    $colorArray[] = $r . $g . $b;

	    $i++;
	}

	if(empty($colorArray)) throw new Exception('No colors generated');

	return $colorArray;

    } //generateRandom()

/*  =========================================================================
    FUNCTION: textColorDiff()
    --------------------------------- notes ---------------------------------
        Hex is a choice made at design time.  Mainly, it is for the
 	exercise and because that is what, historically, I have used the
 	most. Obviously, this could easily be adapted to take in rgb(a)
 	variables.
    ========================================================================= */
    public function textColorDiff($hex)
    {
        $hexParts = str_split($hex, 2);
        $red = hexdec($hexParts[0]);
        $green = hexdec($hexParts[1]);
        $blue = hexdec($hexParts[2]);

        $brightness = (($red * 299) + ($green * 587) + ($blue * 114)) / 1000;

        $whiteDiff = (max($red,255) -  min($red,255)) + (max($green,255) -
                      min($green,255)) + (max($blue,255) -  min($blue,255));
        $blackDiff = (max($red,0) -  min($red,0)) + (max($green,0) -
                      min($green,0)) + (max($blue,0) -  min($blue,0));

	$shade = $whiteDiff > $blackDiff ? 'light' : 'dark';

	if(!$shade) throw new Exception('Could not adjust shades');

	return $shade;

    } //textColorDiff()
}
/*  ---------------------------- eof Colors.php ----------------------------- */
?>