<?php
    define('SITEROOT','../../');

    // Load up the Colors class and instantiate it.
    require_once('./Colors.php');

    $oColors = new Colors;

    // how many colors? null generates a random number of colors up to 100
    $colorQuantity  = null;

    // do we want to adjust the color of the labels to contrast with the
    // background?
    $adjustLabels   = true;

    // if we're not adjusting labels, we'll use this
    $defaultShade   = 'dark';

    // If we are adjusting, we can use the colors provided here.
    // We don't want to include the hash so we can abuse them
    // mathematically if we wish.
    $textShades	    = array('light'=>'FFFFFF','dark'=>'000000');

    try
    {
        $items = array();

        // Get a random stack of colors to use.
        $colorStack = $oColors->generateRandom($colorQuantity);

        // process the returned colors into sets of the info needed to
        // render the result easily in the html.
	foreach($colorStack as $inx=>$colorValue)
	{
            // Here we'll find out what label to use for this set.
	    $shade = $adjustLabels ? $oColors->textColorDiff($colorValue) : $defaultShade;

            // Randomly pick which of our two templates to use.
	    $templateToUse = rand(1,2);


	    $items[$inx]['colorValue'] = strtoupper($colorValue);
	    $items[$inx]['templateToUse'] = strtoupper($templateToUse);
	    $items[$inx]['textShade'] = $textShades[$shade];
	}
    }
    catch (Exception $e)
    {
	echo 'Caught exception: ',  $e->getMessage(), "\n";
    }

    //bring in our little html page to assist with the output
    include_once('colors_index_view.php');
?>